#include "xab.h"
#include <stdio.h>
#include <math.h>

/*
	Host program driver for column Cholesky factorization
	of a symmetric matrix partitioned by vertical strips
	USAGE: cholhost <numprocs> <order of matrix> <stripsize>
*/

main(argc,argv)
int argc;
char **argv;
/* host process */
{
	char temp[32];
	int tmp;
	float f0, f1[4], err, secs[4], mflops[3], eff[3] ;
	int info[3], *map ;
	int me, p, n, blksize, i, j, nprocs;

	if (argc < 4)  { 
		printf("Usage: cholhost #procs N blksize \n"); 
		exit(0);
	}
	nprocs = atoi(*++argv);
	p = nprocs;
	n = atoi(*++argv);
	if (n < p) {
		printf("Problem size (%d) < nprocs (%d)\n",n,p);
		exit(1);
	}
	blksize = atoi(*++argv);
	if (blksize > n/p) blksize = n/p ;

	me = enroll("cholhost");
	for (i=0;i<nprocs;i++) 
		initiate("cholnode", (char*)0);

	whoami(temp,&tmp);
	fprintf(stderr, "I am %s, instance %d\n",temp,tmp);


	initsend();
	info[0] = n ; 
	info[1] = 0;
	info[2] = p; 
	putnint(info,3);
#ifdef USE_VC
	if (vsnd("cholnode",-1,16001) < 0)
#else
	if (snd("cholnode",-1,16001) < 0)
#endif
		{
		printf("HOST: Broadcast of 16001 failed!\n");
		for (i=0;i<nprocs;i++) terminate("cholnode",i);
		leave();
		exit(1);
	}

	map = (int *)malloc(n*sizeof(int)) ;
	for ( i = 0 ; i < n ; i++ ) map[i] = ((i/blksize)%p);

	initsend(0);
	putnint(map,n);
#ifdef USE_VC
	if (vsnd("cholnode",-1,16002) < 0)
#else
	if (snd("cholnode",-1,16002) < 0)
#endif
		{
		printf("HOST: send map (partitioning info) failed!!!\n");
		for (i=0;i<nprocs;i++) terminate("cholnode",i);
		leave();
		exit(1);
	}

	printf("Number of processors = %d, order of matrix = %d\n", p, n) ;
	printf("Cholesky factorization - wrap mapping, natural ordering, ");
	printf("blocksize = %d\n",blksize);
	printf("Full topology, fan-out factorization, synchronous algorithm\n");
	err=0.0;
	
	for (i=0;i<p;i++) {
#ifdef USE_VC
		tmp=vrcv(16003);
#else
		tmp=rcv(16003);
#endif
		getnfloat(&f0,1);
		if (f0 > err) err=f0;
	}
	printf("maxerr\t%e\n", err) ;

	for (i=0;i<4;i++) secs[i]=0.0;
	
	for (i=0;i<p;i++) {
#ifdef USE_VC
		vrcv(16004);
#else
		rcv(16004);
#endif
		getnfloat(f1,4); 
		for (j=0;j<4;j++) if (f1[j] > secs[j]) secs[j] = f1[j];
	}

	printf("      \t factor\t fsolve\t bsolve\t total\n") ;
	printf("secs  \t%7.2f\t%7.2f\t%7.2f\t%7.2f\n", secs[0], secs[1], 
		secs[2], secs[3]) ;
	free(map) ;

	leave();
}
